package net.sf.umlspeed.entities;

import java.util.HashMap;
import java.util.Map;

public class DiagramLink implements Entity {
    
    private DiagramElement targetEntity = null;
    private int linkType = 0;
    private Map renderData = new HashMap();
    private String name = "";
    
    public final static int LINK_EXTENDS = 0;
    public final static int LINK_IMPLEMENTS = 1;
    public final static int LINK_ONETOONE = 2;
    public final static int LINK_ONETOMANY = 3;
    public final static int LINK_MANYTONE = 4;
    public final static int LINK_MANYTOMANY = 5;
    public final static int LINK_USES = 6;
    public final static int LINK_INCLUDES = 7;
    public final static int LINK_DEPENDS = 8;
    
    /**
     * @return the linkType
     */
    public int getLinkType() {
        return linkType;
    }
    /**
     * @param linkType the linkType to set
     */
    public void setLinkType(int linkType) {
        this.linkType = linkType;
    }
    /**
     * @return the targetEntity
     */
    public DiagramElement getTargetEntity() {
        return targetEntity;
    }
    /**
     * @param targetEntity the targetEntity to set
     */
    public void setTargetEntity(DiagramElement targetEntity) {
        this.targetEntity = targetEntity;
    }
    /**
     * @return the renderData
     */
    public Map getRenderData() {
        return renderData;
    }
    /**
     * @param renderData the renderData to set
     */
    public void setRenderData(Map renderData) {
        this.renderData = renderData;
    }
    /**
     * @return the name
     */
    public String getName() {
        return name;
    }
    /**
     * @param name the name to set
     */
    public void setName(String name) {
        this.name = name;
    }
    
    
}
