package net.sf.umlspeed.svg;

import java.util.List;

public abstract class SVGLayout {

    /** Adds an object to the layout */
    public abstract void add(SVGEntity e);
    
    /** Removes an object from the layout */
    public abstract void remove(SVGEntity e);
    
    /** Returns the SVGEntity objects being managed by the layout */
    public abstract List getObjects();
    
    /** Rendered width of layout */
    public abstract int getWidth();
    
    /** Rendered height of layout */
    public abstract int getHeight();
    
    /** Renders the entire document as SVG and returns it
     *  as a string.
     * @return The SVG document.
     */
    public abstract String render();
    
    /** For a given cellsize, entitysize and position, calculates
     *  The offset necessary to center the entity within the cell and
     *  returns the new position.
     * @param cellsize The size of the cell
     * @param entitySize The size of the entity
     * @param cellLocation The x,y co-ordinates of the cell location
     * @return A position to center the entity in the cell.
     */
    protected SVGPosition centerInCell(SVGDimension cellsize, SVGDimension entitySize, SVGPosition cellLocation) {
        int x = 0;
        int y = 0;
        x = cellLocation.x + (cellsize.width - entitySize.width) / 2;
        y = cellLocation.y + (cellsize.height - entitySize.height) / 2;
        return new SVGPosition(x, y);
    }
    
}
